var FINControl=new Object();

    FINControl.ResetFIN=function()
	{
		
		FINControl.ClearAccessCount();
        FINVars.CurrentLanguage = language;//'EN';	
        FINVars.CurrentNode = 'N000';
		FINVars.CurrentTab = 'T001';
		FINState.TabHistory[0] = FINVars.CurrentTab;
		FINControl.UpdateTesting();
        FINVars.CurrentScreen = Nodes[FINVars.CurrentNode].ScreenID;
        FINControl.HandleNodeType();
		FINControl.ChangeSignalStrengthImage();
    }
    

	// clears the AccessCount value from every Node
	 FINControl.ClearAccessCount=function(){
		for (var NodeName in Nodes) {
			Nodes[NodeName].AccessCount = 0;
		}
		
	}
	
	
	
	
	// clears current node/screen and testing data such as breadcrumbs
    FINControl.ClearStates=function()
	{
       
	   FINControl.ClearAccessCount();
	   
	   FINVars.CurrentNode = '';
        FINVars.CurrentScreen = '';
		if(document.testing.Screen){
				document.testing.Screen.value = "";
		}
		FINState.NodeHistory=Array();
		FINState.TabHistory=Array();
		FINState.Breadcrumbs = Array();
		
    }
    



	// executes when Back button is clicked
	FINControl.BackClicked=function(){
		FINVars.CurrentNode = FINState.Breadcrumbs[FINState.Breadcrumbs.length - 1];
		FINState.Breadcrumbs.pop();
		FINControl.PopNodeHistory(FINVars.CurrentNode);
		FINControl.UpdateTesting();
		FINState.Breadcrumbs.pop();
		FINControl.HandleNodeType();
	}
	
	
	
	FINControl.PopNodeHistory=function(NodeScreen){
		var Lengths = FINState.NodeHistory.length;
		for(i=0;i<=Lengths;i++){ // loop
			var Pop = FINState.NodeHistory.pop(); // remove one node from history
			if(Pop){
				var ThisTab = Nodes[Pop].ParentTab; 
				if(ThisTab==FINVars.CurrentTab){
					var PopTab = FINState.TabHistory.pop();	
					FINVars.CurrentTab = FINState.TabHistory[FINState.TabHistory.length-1];
				}
				if(Nodes[Pop].ScreenID){
					if (Pop != NodeScreen && Nodes[Pop].ScreenID!=''){
						FINVars.CurrentNode = Pop;
						break;	
					} 
				} else if (Nodes[Pop].Type=="function"){
					if(Nodes[Pop].Function=="Counter"){ // if when going back we encounter a Counter function node ....
						Nodes[Pop].AccessCount--; //we need to subtract one from the nodes AccessCount value
					}
				}
			} else {
				FINControl.ErrorReport('No parent node');
			}
		}
	}


	FINControl.NextClicked=function(NewNode){
		FINControl.HandleNextNode(NewNode);
			
	}



	FINControl.HandleNodeType=function()
	{	
		FINState.NodeHistory[FINState.NodeHistory.length] = FINVars.CurrentNode;
		var nodeType = Nodes[FINVars.CurrentNode].Type; // get node type
		FINControl.UpdateTesting();
		FINControl.UpdateTabHistory();
		
		FINLog.HandleNode(Nodes[FINVars.CurrentNode]);
		
		if (nodeType=='screen'){	// Display Screen
			FINControl.NodeScreen();
		} else if(nodeType=='selection'){	// selection screen
			FINControl.NodeSelection();
		} else if(nodeType=='function'){	// call Function
			FINControl.NodeFunction();
		} else if(nodeType=='decision'){ // Decision based node
			FINControl.NodeDecision();
			
		} else if(nodeType=='tab'){ // tab based node	
			FINControl.NodeTab();
		} else if(nodeType=='start'){ // start node
			FINControl.NodeStart();
		} else if(nodeType=='end'){ // Decision based node
			FINControl.NodeEnd();
		} else {	// Unknown Node Type
			alert("Error: Unknown Screen Type");	
		}
	}
	
	
	FINControl.UpdateTabHistory=function(){
		FINVars.CurrentNodeTab = Nodes[FINVars.CurrentNode].ParentTab;
		if(FINVars.CurrentNodeTab!=FINVars.CurrentTab){
			FINVars.CurrentTab=	FINVars.CurrentNodeTab;
			FINState.TabHistory[FINState.TabHistory.length] = FINVars.CurrentTab;
			FINControl.UpdateTesting();
		}
	}


	// updates breadcrumbs & node history on screen for testing purposes
	FINControl.UpdateTesting=function(){
		document.testing.Breadcrumbs.value = FINState.Breadcrumbs;
		document.testing.NodeHistory.value = FINState.NodeHistory;
		document.testing.TabHistory.value = FINState.TabHistory;	
		
		if(Nodes[FINVars.CurrentNode]){
			if(Nodes[FINVars.CurrentNode].ScreenID){
				document.testing.Screen.value = Nodes[FINVars.CurrentNode].ScreenID; 
			} 
		}
	}

	



	// this function activates when user clicks a selection box
	FINControl.OptionSelected=function(Selected){
		FINVars.SelectedID = Selected.id; // set var
		
		var nodes = FINControl.GetByClass("RadioBoxSelected"), i=-1, node; // select all with class RadioBoxSelected
		while (node=nodes[++i]) {
			node.setAttribute("class", "RadioBox"); // change Class for all selected 
		}
		var Box = "Box" + FINVars.SelectedID;
		document.getElementById(Box).setAttribute("class", "RadioBoxSelected"); // change background style/image
		$('#Next').removeAttr("disabled");
		
	}
	
	
  

	
	// selects all elements with matching class
	FINControl.GetByClass = function(className, parent) {
	  parent || (parent=document);
	  var descendants=parent.getElementsByTagName('*'), i=-1, e, result=[];
	  while (e=descendants[++i]) {
		((' '+(e['class']||e.className)+' ').indexOf(' '+className+' ') > -1) && result.push(e);
	  }
	  return result;
	}
	
	

	
	// this function adds the javascript to selection elements needed for Option Selection
	FINControl.ActivateOptionSelection=function(Content){
		FINVars.SelectedID=''; // this is the var that will contain selected value
		var FindThis = 'class="Radio"';
		var ReplaceWith = 'class="Radio" onClick="FINControl.OptionSelected(this);"';
		Content = Content.replace(new RegExp(FindThis, 'g'),ReplaceWith);
		
		
		var FindThis2 = 'class="RadioSmaller"';
		var ReplaceWith2 = 'class="RadioSmaller" onClick="FINControl.OptionSelected(this);"';
		Content = Content.replace(new RegExp(FindThis2, 'g'),ReplaceWith2);		
		
		return Content;
	}

	


	// returns the selected value of selected option.
	FINControl.getRadioValue=function(){
		
		if(document.forms.selection){	
			if(FINVars.SelectedID){
				RadioValue=FINVars.SelectedID;
				return RadioValue;
			} else {
				
				////////////////////////////////////////////////////////////////////////////////////////////////////
				/////////THIS ALERT NEEDS TO BE REPLACED WITH A PROPER POPUP (Help_SelectFINOption.html)////////////
				
				/*if(CefRunning())
				{
					cef.application.OpenNovusWindow(NovusWindowId_Help_FINSelectAnOption);
				}*/
				////////////////////////////////////////////////////////////////////////////////////////////////////
				
				if(FINVars.CurrentLanguage=="EN"){
					FINFunctions.AlertUser('You must select an option to continue.'); // No option has been selected
				} else if(FINVars.CurrentLanguage=="SE"){
					FINFunctions.AlertUser('Du måste välja ett alternativ för att fortsätta.'); // No option has been selected
				} else {
					FINFunctions.AlertUser('Valitse jotta voit jatkaa.'); // No option has been selected
				}
				
				
				
			}
		} 
	}
		
	
	// handles an error
	FINControl.ErrorReport=function(TheError){
		alert("ERROR: " + TheError);
		
	}
	

	FINControl.HandleNextNode=function(NewNode)
	{		
		if (NewNode instanceof Object)
		{
			// else work out path from Array values
			// from selection screen			
			var SelectValue = FINControl.getRadioValue();
			if(SelectValue)
			{
				if(NewNode[SelectValue]==undefined && NewNode['Other'])
				{ // if OTHER
					FINVars.CurrentNode = NewNode['Other']; //set path
				}
				else
				{
					FINVars.CurrentNode = NewNode[SelectValue]; //set path
				}
				
				FINVars.CurrentScreen = Nodes[FINVars.CurrentNode].ScreenID; // set Current Screen
				var nodeType = Nodes[FINVars.CurrentNode].Type; // get node type
				FINControl.HandleNodeType();
			}
		}
		else
		{
			if(NewNode)
			{
				FINVars.CurrentNode = NewNode;
				if(!Nodes[NewNode])
				{
					FINControl.ErrorReport('Cannot find node in Nodes[] - CurrentNode = ' + FINVars.CurrentNode);
				}
				else if(Nodes[NewNode].ScreenID)
				{
					FINVars.CurrentScreen = Nodes[NewNode].ScreenID;
				}
				var nodeType = Nodes[FINVars.CurrentNode].Type; // get node type
				FINControl.HandleNodeType();
			
			}
			else
			{
				if(FINVars.CurrentNode!='ENDFIN')
				{
					FINControl.ErrorReport('No Node Specified - CurrentNode = ' + FINVars.CurrentNode);
				}
			}
			
		}
	}
	
	
	//swaps SignalStrength image with dynamic image
	FINControl.ChangeSignalStrengthImage=function(SignalStrength)
	{
		//if(!SignalStrength)
		//	return;

		if(SignalStrength == undefined)
		{
		}
		else
			FINVars.SignalStrength = SignalStrength;
			
		console.log("FINControl.ChangeSignalStrengthImage " + FINVars.SignalStrength);
		
		// does image exist?		
		if(document.getElementById("SignalStrength"))
		{
			// change the image src
			document.getElementById("SignalStrength").src="images/SignalStrength/"+FINVars.SignalStrength+".png";
		} 
	}
	
	
	// Replaces any variable in the HTML content parameter of type $$FINVars.VARIABLE$$
	// with said variable
	FINControl.ReplaceVarsInString=function(Content)
	{
		if(!Content)
			return;
		
		var InThere = Content.match(/\$\$(.*?)\$\$/);
		
		if(InThere!=null){
			var FindMatch;
			for(i=0;i<Content.length;i++){
				FindMatch= Content.match(/\$\$(.*?)\$\$/);
				
				if(FindMatch!=null){
					var Replacement = FindMatch[1];
					var ReplacementBranded = Replacement + "_" + FINVars.Brand;
					
					var VarArray = Replacement.split('.');
					var a =VarArray[0];
					var b =VarArray[1];
					var ReplaceText = window[a][b];
					
					var BrandedArray= ReplacementBranded.split('.');
					var c =BrandedArray[0];
					var d =BrandedArray[1];
					var ReplaceTextBranded = window[c][d];					
					
					if(ReplaceTextBranded==undefined){
						if(ReplaceText==undefined){
							Content = Content.replace(FindMatch[0],'<span class="highlighter">Unknown Variable (' + a + '.' + b + ')</span>'); // use error text 
						} else {
							Content = Content.replace(FindMatch[0],ReplaceText); // use non-branded variable
						}						
					} else {
						Content = Content.replace(FindMatch[0],ReplaceTextBranded); // use branded variable
					}
				} else {
					break;
				}
			}
		}
		return Content;
	}
	
	

	
	FINControl.ScreenContent=function(Content)
	{
		Content = FINControl.ReplaceVarsInString(Content);
		
		Content = FINControl.ActivateOptionSelection(Content);
		$('#ScreenContent').html(Content);
		
		FINControl.ChangeSignalStrengthImage();
	}
	
	FINControl.ScreenContentWithPath=function(Content,divID)
	{
		Content = FINControl.ReplaceVarsInString(Content);
		Content = FINControl.ActivateOptionSelection(Content);
		$('#'+divID).html(Content);
	}	
		
	FINControl.DisableButton=function(Button){
		$('#'+Button).hide(); 
		//$('#'+Button+'Disabled').show(); 
	}
	
	
	FINControl.EnableButton=function(Button){
		$('#'+Button).show(); 
		//$('#'+Button+'Disabled').hide(); 		
	}
	
	
	FINControl.DisableAllButtons=function(){
		FINControl.DisableButton('Back');
		FINControl.DisableButton('Next');
		FINControl.DisableButton('Exit');
		FINControl.DisableButton('Finish');
	}
		
	FINControl.Buttons=function(ButtonsArray){
		FINControl.DisableAllButtons();
		for (x in ButtonsArray){
			FINControl.EnableButton(ButtonsArray[x]);
			
		}
	}
	
	// this function displays the timer screen
	FINControl.TimerScreen=function(){
		if(Screens[FINVars.CurrentScreen]){
			
			if(Screens[FINVars.CurrentScreen][FINVars.CurrentLanguage]){
				var HTMLContent = '<div class="ImageLayerStyle">' + Screens[FINVars.CurrentScreen][FINVars.CurrentLanguage]+'</div>';
				// HTMLContent
				if(Screens[FINVars.CurrentScreen][FINVars.CurrentLanguage + '_ImageLayer']){
					HTMLContent = '<div class="ImageLayerStyle">' + Screens[FINVars.CurrentScreen][FINVars.CurrentLanguage + '_ImageLayer'] + '</div>' + '<div class="TextLayerStyle">'+HTMLContent+'</div>';
				}
				FINControl.ScreenContent(HTMLContent);
			} else {
				FINControl.ErrorReport('No Content or Translation for Timer Screen # ' + FINVars.CurrentScreen);
			}
		} else {
			FINControl.ErrorReport('No content for Screen ID # ' + FINVars.CurrentScreen);
		}
	}
	
	
	
	// function to display screen content based on CurrentNode
	FINControl.NodeScreen=function(){
	
		if(Nodes[FINVars.CurrentNode].ScreenID){
			FINVars.CurrentScreen = Nodes[FINVars.CurrentNode].ScreenID; // set the CurrentScreen variable
		} else {
			FINControl.ErrorReport('No Content or Translation for Screen # ' + FINVars.CurrentScreen+' * '); // Error
		}
		
		if(Nodes[FINVars.CurrentNode].Buttons){
			FINControl.Buttons(Nodes[FINVars.CurrentNode].Buttons); // update the buttons
		}
				
		FINState.Breadcrumbs[FINState.Breadcrumbs.length] = FINVars.CurrentNode; // add to breadcrumb string

		if(Screens[FINVars.CurrentScreen]){
			
			if(Screens[FINVars.CurrentScreen][FINVars.CurrentLanguage]){
				var HTMLContent =  '<div class="TextLayerStyle">' +Screens[FINVars.CurrentScreen][FINVars.CurrentLanguage]+'</div>';
				// replace the HTMLContent
				if(Screens[FINVars.CurrentScreen][FINVars.CurrentLanguage + '_ImageLayer']){
					HTMLContent = '<div class="ImageLayerStyle">' + Screens[FINVars.CurrentScreen][FINVars.CurrentLanguage + '_ImageLayer'] + '</div>' + '<div class="TextLayerStyle">'+HTMLContent+'</div>';
				}
				FINControl.ScreenContent(HTMLContent);
			} else {
				FINControl.ErrorReport('No Content or Translation for Screen # ' + FINVars.CurrentScreen); // Translation is missing
				if(Screens[FINVars.CurrentScreen]['EN']){
					FINControl.ScreenContent('<div class="TextLayerStyle">'+Screens[FINVars.CurrentScreen]['EN']+'</div>'); // display English version if avail.
				} else {
					FINControl.ScreenContent('<div class="TextLayerStyle"><h1>Screen Missing!</h1></div>'); //  or display error !
				}
			}
		} else {
			FINControl.ErrorReport('No content for Screen ID # ' + FINVars.CurrentScreen);
		}
		FINControl.UpdateTesting(); // updates on screen testing information
	}
	
	FINControl.NodeTab=function(){
		var NewTab =Nodes[FINVars.CurrentNode].TabID; // Tab
		if(Tabs[NewTab]){
			var NewNode = Tabs[NewTab].FirstNode;
			FINControl.HandleNextNode(NewNode); // go to next node			
		} else {
			FINControl.ErrorReport('undefined tab, current node = '+FINVars.CurrentNode);
		}
	}
	

	FINControl.NodeStart=function()
	{	
		var NewNode =Nodes[FINVars.CurrentNode].NextNode; 
		FINControl.HandleNextNode(NewNode); // go to next node		
	}
	
	
	FINControl.NodeEnd=function(){
		var ThisTab = FINVars.CurrentTab;//get CurrentTab
		var AllTabs = new Array();
		// copy nodes from history into new array
		for(x=0;x<FINState.TabHistory.length;x++){
			AllTabs[x] = FINState.TabHistory[x];
		}
		var PrevTab = AllTabs.pop();// find previous tab
		PrevTab = AllTabs.pop();
		// from prev tab get the next node
		var AllNodes = new Array();
		// copy nodes from history into new array
		for(e=0;e<FINState.NodeHistory.length;e++){
			AllNodes[e] = FINState.NodeHistory[e];
		}
		var NodeLengths = AllNodes.length;
		
		for(i=0;i<=NodeLengths;i++){ // loop
			var Pop = AllNodes.pop(); // remove one node 
			if(Nodes[Pop]==undefined){
				FINControl.ErrorReport('Current Node is undefined*');
				break;
			} else {
				
				if(Nodes[Pop].ParentTab){
					var ThisTab = Nodes[Pop].ParentTab; // get this nodes tab
					if(ThisTab==PrevTab){ // if tab mathces
						// get next node
						var TheNextNode = Nodes[Pop].NextNode;
						break;
					}
				} else {
					FINControl.ErrorReport('No parent tab set for: ' + Nodes[Pop]);
					
				}
			}
		}
		FINControl.UpdateTesting();
		if(TheNextNode){
			var x = FINState.TabHistory.pop();
			FINVars.CurrentTab = PrevTab;
			FINControl.HandleNextNode(TheNextNode);
		} else {
			FINControl.ErrorReport('Next node is undefined');
		}
	}


	FINControl.NodeSelection=function(){
		FINControl.NodeScreen();
		// disable next button.
		//document.getElementById("Next").style.display="none";
		//document.getElementById("NextDisabled").style.display="block";
		$('#Next').attr('disabled','true');
		
	}
	
	

	FINControl.NodeFunction=function()
	{
		if(Nodes[FINVars.CurrentNode] && Nodes[FINVars.CurrentNode].Function == 'Counter') //special case for "Counter"
		{
			
			if(Nodes[FINVars.CurrentNode].AccessCount == undefined){
				Nodes[FINVars.CurrentNode].AccessCount = 1;
			}
			else
			{
				Nodes[FINVars.CurrentNode].AccessCount++;
			}
				
			FINControl.FunctionPath(Nodes[FINVars.CurrentNode].AccessCount.toString());
		}
		else if(CefRunning())
		{
			FINControl.FunctionPath();
		}
		else
		{	
			FINControl.DisableButton('Back');
			FINControl.DisableButton('Finish');
			FINControl.DisableButton('Next');
			var obj = Nodes[FINVars.CurrentNode].NextNode; // options
			var FunctionName = Nodes[FINVars.CurrentNode].Function; // get function name.
			var Variable = Nodes[FINVars.CurrentNode].Variable;
			var str = '<BR><div class="decider functions">(function) <b>'+FunctionName+'</b> : Click one of the following:<br><br><select  onchange="FINControl.FunctionPath();" name=SelectOptions id="SelectOptions"><option></option>';
			Object.keys(obj).forEach(function(key) {
					str=str+"<option value=\""+key+"\">"+key+"</option>";
			});		
			str = str + "</select></div>";		
			FINControl.ScreenContent(str);
		}
	}
	
	FINControl.FunctionReturn=function(ReturnValue)
	{	
		if(Nodes[FINVars.CurrentNode]==undefined){
			FINControl.ErrorReport('Current Node is undefined '); 
		} else {
			if(Nodes[FINVars.CurrentNode].NextNode){
				var NextNodes =Nodes[FINVars.CurrentNode].NextNode;
				var NewNode = NextNodes[ReturnValue]; //set path
				FINControl.HandleNextNode(NewNode);
			} else {
				FINControl.ErrorReport('No NextNode set for :' + FINVars.CurrentNode);
				
			}
		}	
	}
	
	FINControl.FunctionPath=function(thePath)
	{
		var ReturnValue;
		var FunctionName = Nodes[FINVars.CurrentNode].Function; // get function name.
		var FunctionParam = Nodes[FINVars.CurrentNode].FunctionParam;
	
		
		if(thePath)
		{
			FINControl.FunctionReturn(thePath);
		}		
		else if(CefRunning())
		{
			FINFunctions[FunctionName](FunctionParam); // call function
		}
		else
		{
			ReturnValue = $("#SelectOptions").val();		// or get value from dropdown
			FINControl.FunctionReturn(ReturnValue);
		}		
	}
	
	
		

	FINControl.NodeDecision=function()
	{	
		if(CefRunning())
		{
			FINControl.DecisionPath();
		}
		else
		{	
			FINControl.DisableButton('Finish');
			FINControl.DisableButton('Back');
			FINControl.DisableButton('Next');
			var obj = Nodes[FINVars.CurrentNode].NextNode; // options
			var Variable = Nodes[FINVars.CurrentNode].Variable;
			var str = '<BR><div class="decider">DECISION: <b>Click one of the following:</b><br><br><select  onchange="FINControl.DecisionPath();" name=SelectOptions id="SelectOptions"><option></option>';
			Object.keys(obj).forEach(function(key) {
					str=str+"<option value=\""+key+"\">"+key+"</option>";
			});		
			str = str + "</select></div>";		
			FINControl.ScreenContent(str);

		}
	}
	
	
	FINControl.DecisionPath=function()
	{	
		// get selected
		var selected;
		// get variable
		var Variable = Nodes[FINVars.CurrentNode].Variable;
		if(CefRunning())
		{
			selected = FINVars[Variable];
		}
		else
			selected = $("#SelectOptions").val();
		
		// set path direction
		var Paths = Nodes[FINVars.CurrentNode].NextNode; // options
		var ThePath = Paths[selected]; //set path
		
		if(ThePath == undefined)
			ThePath = Paths['Other']; //set path
		
		FINControl.HandleNextNode(ThePath); 		
		
	}



